package cn.com.duiba.oto.elasticsearch;

/**
 * @author linjianhui
 * @description 匹配规则
 * @date 2020-02-07 15:22
 */
public enum EsMatchMode {
    /**
     * 文档必须匹配这些条件才能被包含进来。
     */
    MUST,

    /**
     * 文档必须不匹配这些条件才能被包含就来。
     */
    MUST_NOT,

    /**
     * 如果满足这些语句中的任意语句，将增加_score,否则无任何影响，主要用于修正每个文档的相关性得分（即匹配度优先级）。
     */
    SHOULD,

    /**
     * 必须匹配，但他以不评分、过滤模式来进行，这些语句对评分没有贡献，只是根据过滤标准来排除或包含文档。
     */
    FILTER,
    ;
}
