package cn.com.duiba.oto.elasticsearch;

/**
 * @author linjianhui
 * @description 查询规则
 * @date 2020-02-07 15:23
 */
public enum EsQueryMode {
    /**
     * 不会对搜索词进行分词处理，而是作为一个整体与目标字段进行匹配，若完全匹配，则可查询到。
     */
    TERM_QUERY,

    /**
     * 不会对搜索词进行分词处理，而是作为一个整体与目标字段进行匹配，若完全匹配，则可查询到；
     * 一次匹配多个值，类似mysql中的 in 操作
     */
    TERMS_QUERY,

    /**
     * 会将搜索词分词，再与目标查询字段进行匹配，若分词中的任意一个词与目标字段匹配上，则可查询到。
     * 如 我是中国人  被分词器拆分后可能会变成 我 我是 中国 中国人 这四个term
     * 如 你搜索 我是中 会先分词 我 我是 然后去匹配，优先找匹配评分高的
     */
    MATCH_QUERY,

    /**
     * 通配符查询
     * 会将查询条件拼接成  *我是中*  去匹配
     * 像mysql的LIKE
     */
    WILDCARD_QUERY,

    /**
     * 多条件，满足一个即可，类似mysql多 or操作
     */
    SHOULD_BOOL_QUERY,

    /**
     * 检索词分词检索
     * <p>
     *     华为手机 -> 华为、手机 (ik_smart)
     *     and 两个条件都要满足
     * </p>
     */
    ANALYZER_AND_QUERY,

    /**
     * 检索词分词检索
     * <p>
     *     华为手机 -> 华为、手机 (ik_smart)
     *     or 两个条件满足一个就行
     * </p>
     */
    ANALYZER_OR_QUERY,

    /**
     * 小于
     */
    LT_QUERY,

    /**
     * 大于
     */
    GT_QUERY,
    /**
     * 小于等于
     */
    LT_EQUALS_QUERY,

    /**
     * 大于等于
     */
    GT_EQUALS_QUERY,

    /**
     * 种草定制类型
     */
    GRASS_CONTENT_SEARCH_QUERY,

    /**
     * 发圈素材定制类型
     */
    TIME_TIMING_CONTENT_SEARCH_QUERY,
    ;
}
