package cn.com.duiba.oto.param.oto.conversation;

import cn.com.duiba.oto.param.oto.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * @author liuyj
 * @date 2022/9/14 14:40
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class WxWorkListParam extends PageQuery implements Serializable {
    /**
     * 发送范围查询开始时间
     */
    private String beginMsgTime;

    /**
     * 发送范围查询结束时间
     */
    private String endMsgTime;

    /**
     * 消息搜索
     */
    private String msgContent;

    /**
     * 客户/客户群
     */
    private String custOrCustRoomSearchContent;

    /**
     * 员工姓名转员工ID查询
     */
    private List<Long> sellerIds;
    /**
     * 聊天类型 1 内部单聊 2 外部单聊 3 内部群聊 4 外部群聊
     */
    private Integer convType;
}
