package cn.com.duiba.oto.param.oto.elasticsearch;

import cn.com.duiba.oto.param.oto.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.Date;
import java.util.List;

/**
 * @author liuyj
 * @date 2022/10/12 11:36
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class EsWxMsgContentSearchParam extends PageQuery {
    /**
     * 客户/客户群
     */
    private String custOrCustRoomSearchContent;

    /**
     * 消息内容（只存会话消息） 如果是图片，则该字段为空
     */
    private String content;

    /**
     * 发送范围查询开始时间
     */
    private Date beginMsgTime;

    /**
     * 发送范围查询结束时间
     */
    private Date endMsgTime;

    private List<String> userKeys;

    /**
     * 聊天类型 1 内部单聊 2 外部单聊 3 内部群聊 4 外部群聊
     */
    private Integer convType;
}
