package cn.com.duiba.oto.param.oto.wxwork;

import cn.com.duiba.oto.param.oto.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 部门信息表
 * @author kjj mybatis generator 
 * @date 2022-10-08
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class OtoDepartmentSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 16651999029933226L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 部门id
     */
    private Integer deptId;

    /**
     * 部门名称
     */
    private String name;

    /**
     * 英文名称
     */
    private String nameEn;

    /**
     * 部门负责人的UserID(集合)
     */
    private String departmentLeader;

    /**
     * 父部门id。根部门为1(parentid=1时表示已经是最顶层部门)
     */
    private Integer parentid;

    /**
     * 在父部门中的次序值。order值大的排序靠前。值范围是[0, 2^32)
     */
    private Integer deptOrder;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}