/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.oto.enums.cust.ext;

import cn.com.duiba.kjy.base.api.utils.NumberUtil;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public enum OtoCustValueEnum {
    X("X", 101, 1, "\u62e8\u6253\u672a\u63a5\u901a\u6b21\u6570 >= 5"),
    N("N", 102, 2, "\u62e8\u6253\u6b21\u65705\u6b21\u5185\u672a\u63a5\u901a"),
    NULL("", 0, 4, "\u9ed8\u8ba4\u4e3a\u7a7a"),
    ZERO("0", 200, 3, "\u9500\u552e\u624b\u52a8\u8f93\u5165"),
    ONE("1", 201, 5, "\u9500\u552e\u624b\u52a8\u8f93\u5165"),
    TWO("2", 202, 6, "\u9500\u552e\u624b\u52a8\u8f93\u5165"),
    THREE("3", 203, 7, "\u9500\u552e\u624b\u52a8\u8f93\u5165"),
    THREE_A("3-A", 301, 10, "\u9012\u4ea4\u4e86\u8ba1\u5212\u4e66\uff0c\u8fd1\u671f\u6709\u673a\u4f1a\u6210\u4ea4"),
    THREE_B("3-B", 302, 9, "\u9012\u4ea4\u4e86\u8ba1\u5212\u4e66\uff0c\u8fd1\u671f\u65e0\u6cd5\u6210\u4ea4"),
    THREE_C("3-C", 303, 8, "\u9012\u4ea4\u4e86\u8ba1\u5212\u4e66,\u62d2\u7edd");

    private final String showValue;
    private final Integer realValue;
    private final Integer sort;
    private final String desc;
    public static final Set<Integer> LOWER_VALUE_LIST;
    public static final Set<Integer> NUMBER_VALUE_LIST;
    private static final Map<Integer, String> ALL_MAP;
    private static final Map<Integer, Integer> SORT_MAP;

    public static String getShowValue(Integer realValue) {
        if (NumberUtil.isNullOrLteZero((Integer)realValue)) {
            return null;
        }
        return ALL_MAP.get(realValue);
    }

    public static Integer getSort(Integer realValue) {
        if (NumberUtil.isNullOrLteZero((Integer)realValue)) {
            return null;
        }
        return SORT_MAP.get(realValue);
    }

    public static boolean humanReplace(Integer oldValue, Integer newValue) {
        if (newValue == null) {
            return false;
        }
        if (newValue.equals(oldValue)) {
            return true;
        }
        return N.getRealValue().equals(newValue) || ZERO.getRealValue().equals(newValue) || ONE.getRealValue().equals(newValue) || TWO.getRealValue().equals(newValue);
    }

    public String getShowValue() {
        return this.showValue;
    }

    public Integer getRealValue() {
        return this.realValue;
    }

    public Integer getSort() {
        return this.sort;
    }

    public String getDesc() {
        return this.desc;
    }

    private OtoCustValueEnum(String showValue, Integer realValue, Integer sort, String desc) {
        this.showValue = showValue;
        this.realValue = realValue;
        this.sort = sort;
        this.desc = desc;
    }

    static {
        LOWER_VALUE_LIST = Collections.unmodifiableSet(Sets.newHashSet((Object[])new Integer[]{X.getRealValue(), N.getRealValue(), ZERO.getRealValue()}));
        NUMBER_VALUE_LIST = Collections.unmodifiableSet(Sets.newHashSet((Object[])new Integer[]{ZERO.getRealValue(), ONE.getRealValue(), TWO.getRealValue(), THREE.getRealValue()}));
        ALL_MAP = Collections.unmodifiableMap(Arrays.stream(OtoCustValueEnum.values()).collect(Collectors.toMap(OtoCustValueEnum::getRealValue, OtoCustValueEnum::getShowValue)));
        SORT_MAP = Collections.unmodifiableMap(Arrays.stream(OtoCustValueEnum.values()).collect(Collectors.toMap(OtoCustValueEnum::getRealValue, OtoCustValueEnum::getSort)));
    }
}

