package cn.com.duiba.oto.dto.oto.cust.custImport.param;

import cn.com.duiba.oto.enums.cust.OtoCustLevelEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author xiaotian
 * @version 1.0
 * @date 2022-06-29 09:52
 */
@Data
public class CustImportBaseBean implements Serializable {

    private static final long serialVersionUID = -4295570808816236640L;

    /**
     * 客户手机号
     */
    private String phoneNum;

    /**
     * 客户来源
     * @see cn.com.duiba.oto.enums.cust.CustFromSourceEnum
     */
    private String custFromSource;

    /**
     * 客户所属产品组
     */
    private List<Long> companyIds;

    /**
     * 客户姓名(允许为空，为空时默认等级为空字符串)
     */
    private String custName = "匿名客户";

    /**
     * 客户等级(允许为空，为空时默认等级为B)
     */
    private Integer custLevel = OtoCustLevelEnum.B.getCustLevel();

}
