package cn.com.duiba.oto.oto.service.api.remoteservice.log;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.log.CustOptLogDto;
import cn.com.duiba.oto.param.oto.log.OtoLogSearchParam;

import java.util.List;

/**
 * @author xiaotian
 * @version 1.0
 * @date 2022-01-13 14:33
 */
@AdvancedFeignClient
public interface RemoteOtoCustOptLogService {

    /**
     * 根据客户id和销售id以及时间查询日志（时间逆序）
     * @param param 查询参数
     * @return 日志列表
     */
    List<CustOptLogDto> listByCustIdAndTime(OtoLogSearchParam param);

    /**
     * 根据日志id判断有没有下一条
     * @param param 查询参数
     * @return 是否有下一条
     */
    boolean hasNext(OtoLogSearchParam param);
    /**
     * 记录打电话的日志
     * @param custId 客户id
     * @param sellerId 销售id
     * @param callTimeLength 通话时长
     */
    void logCall(Long custId, Long sellerId, Integer callTimeLength);

    /**
     * 根据客户id，操作场景opt_scene，操作key opt_key查询日志记录
     */
    List<CustOptLogDto> selectByParam(Long custId, Integer optScene, String optKey);
}
