package cn.com.duiba.oto.enums.cust;

import com.google.common.collect.ImmutableMap;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author xiaotian
 */
@Getter
@AllArgsConstructor
public enum CustLiveActionEnum {
    /**
     * 客户性别
     */
    PRESENT("已到场", 1),
    PRIZE("已获奖", 2),
    FORM("已填单", 3);

    private final String desc;
    private final Integer code;
    private static final ImmutableMap<Integer, CustLiveActionEnum> INNER_MAP;

    static {
        ImmutableMap.Builder<Integer, CustLiveActionEnum> builder = ImmutableMap.builder();
        for (CustLiveActionEnum item : CustLiveActionEnum.values()) {
            builder = builder.put(item.code, item);
        }
        INNER_MAP = builder.build();
    }

    public static CustLiveActionEnum getByCode(Integer code) {
        return INNER_MAP.get(code) == null ? null : INNER_MAP.get(code);
    }
}
