package cn.com.duiba.oto.oto.service.api.remoteservice.cust;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.cust.MaxAndMinStrategySortNumDto;
import cn.com.duiba.oto.dto.oto.cust.OtoCheckStrategyDto;
import cn.com.duiba.oto.param.oto.cust.*;

import java.util.List;


@AdvancedFeignClient
public interface RemoteOtoCheckStrategyService {

    /**
     * 查询策略配置 支持分页
     * @param param 查询条件
     */
    List<OtoCheckStrategyDto> list(OtoCheckStrategySearchParam param);

    /**
     * 查询策略配置
     *
     * @param param 查询条件
     */
    List<OtoCheckStrategyDto> selectByParam(OtoCheckStrategySearchParam param);

    /**
     * 查询策略配置
     */
    OtoCheckStrategyDto selectById(Long id);

    /**
     * 查询策略配置总条数
     *
     * @param param 查询条件
     */
    Long count(OtoCheckStrategySearchParam param);

    /**
     * 新增策略配置
     *
     * @param param
     * @return
     */
    OtoCheckStrategyDto save(OtoCheckStrategyParam param);

    /**
     * 修改策略配置
     *
     * @param param
     * @return
     */
    boolean update(OtoCheckStrategyParam param);

    /**
     * 查询最大和最小序号
     * @return
     */
    MaxAndMinStrategySortNumDto selectMaxAndMinStrategyId();

    /**
     * 批量修改
     * @param params 参数
     * @return 结果
     */
    boolean batchUpdate(List<OtoCheckStrategyParam> params);
}
