package cn.com.duiba.oto.oto.service.api.remoteservice.tag;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.tag.OtoRoleTeamTagRefDto;
import cn.com.duiba.oto.param.oto.OtoTagDto;

import java.util.List;

@AdvancedFeignClient
public interface RemoteOtoRoleTeamTagService {

    /**
     * 根据标签ID查询
     *
     * @param tagIds
     * @return
     */
    List<OtoRoleTeamTagRefDto> getAllByTagIds(List<Long> tagIds);

    /**
     * 批量保存角色和可见团队
     *
     * @param dtos
     * @return
     */
    int batchSave(List<OtoRoleTeamTagRefDto> dtos);

    /**
     * 根据标签ID批量删除
     *
     * @param tagIds 标签ID
     */
    int batchDelete(List<Long> tagIds);

    /**
     * 根据
     *
     * @param roleTypes 角色类型
     * @param sellerIds 团队长
     */
    List<OtoRoleTeamTagRefDto> listBySellerIdAndRoleType(List<Integer> roleTypes, List<Long> sellerIds);
}
