package cn.com.duiba.oto.dto.oto.wxwork;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 企微群成员信息表
 * @author kjj mybatis generator 
 * @date 2022-10-08
 */
@Data
public class OtoWxUserGroupChatDto implements Serializable {
     
    private static final long serialVersionUID = 16651994400651988L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 群聊ID
     */
    private String chatId;

    /**
     * 同一个企业内容为userid，非相同企业为external_userid
     */
    private String userKey;

    /**
     * 成员类型。1 - 企业成员 2 - 外部联系人
     */
    private Integer type;

    /**
     * 外部联系人在微信开放平台的唯一身份标识（微信unionid）
     */
    private String unionid;

    /**
     * 入群时间
     */
    private Date joinTime;

    /**
     * 入群方式。1 - 由群成员邀请入群（直接邀请入群）2 - 由群成员邀请入群（通过邀请链接入群）3 - 通过扫描群二维码入群
     */
    private Integer joinScene;

    /**
     * 邀请者user_key。目前仅当是由本企业内部成员邀请入群时会返回该值
     */
    private String invitor;

    /**
     * 名字。仅当 need_name = 1 时返回 如果是微信用户，则返回其在微信中设置的名字 如果是企业微信联系人，则返回其设置对外展示的别名或实名
     */
    private String userName;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 类型:1 - 企微 2 - 云客个微
     */
    private Integer fromSource;
}