package cn.com.duiba.oto.oto.service.api.remoteservice.interview;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.interview.AppointmentDetailDTO;
import cn.com.duiba.oto.dto.oto.interview.InterviewDetailDTO;
import cn.com.duiba.oto.dto.oto.interview.InterviewEditDetailDTO;
import cn.com.duiba.oto.dto.oto.interview.OtoCustInterviewDto;
import cn.com.duiba.oto.dto.oto.interview.OtoCustInterviewRecordDTO;
import cn.com.duiba.oto.dto.oto.interview.OtoCustomerInterviewListDTO;
import cn.com.duiba.oto.dto.oto.interview.OtoCustomerPhoneDTO;
import cn.com.duiba.oto.dto.oto.interview.OtoCustomerViewDTO;
import cn.com.duiba.oto.dto.oto.interview.OtoInterviewListDto;
import cn.com.duiba.oto.dto.oto.seller.OtoSellerDTO;
import cn.com.duiba.oto.param.oto.interview.CreateInterviewParam;
import cn.com.duiba.oto.param.oto.interview.CustomerBindWxUserParam;
import cn.com.duiba.oto.param.oto.interview.InterviewAuthorizeEvaluateParam;
import cn.com.duiba.oto.param.oto.interview.InterviewFeedbackParam;
import cn.com.duiba.oto.param.oto.interview.OtoCustInterviewRecordSaveParam;
import cn.com.duiba.oto.param.oto.interview.OtoCustomerInterviewSaveAddressParam;
import cn.com.duiba.oto.param.oto.interview.OtoCustomerInterviewStatusParam;
import cn.com.duiba.oto.param.oto.interview.OtoQueryInterviewRecordParam;

import java.util.List;

/**
 * 描述：手机工作台1.0，客户面访
 *
 * @author zhouziwu
 * @date 2022-03-23
 */
@AdvancedFeignClient
public interface RemoteCustInterviewService {
    /**
     * 客户参观社区，查询预约面访详情
     * @param custId 客户id
     * @param sellerId 销售id
     * @param interviewType 面访类型，1:普通面访 2:社区面访
     * @param interviewStatus 面访状态：{@link cn.com.duiba.oto.enums.OtoCustInterviewStatusEnum}
     * @return AppointmentDetailDTO
     */
    AppointmentDetailDTO findAppointmentDetail(Long custId, Long sellerId, Integer interviewType, List<Integer> interviewStatus);

    /**
     * 批量创建面访时，预检查
     * @param param 参数
     * @return
     * @throws BizException
     */
    Boolean preCheckCustCanInterview(CreateInterviewParam param) throws BizException;

    /**
     * 批量创建客户面访记录
     * @param param 参数
     * @return info
     */
    List<Long> batchSaveInterviewInfo(CreateInterviewParam param) throws BizException;

    /**
     * 更新面访码id
     * @param id 面访表主键
     * @param scanCodeId 面访码id
     * @return int
     */
    Boolean updateScanCodeIdById(Long id, Long scanCodeId);

    /**
     * 参观社区-预约面访编辑
     * @param editDetailDTO
     * @return
     */
    Boolean updateInterviewRecord(InterviewEditDetailDTO editDetailDTO);

    /**
     * 查看上传面访的信息
     * @param id Id
     * @return detail info
     */
    InterviewDetailDTO findInterviewDetail(Long id);

    /**
     * 进入面访信息上传页面时回显信息的接口
     * @param id id
     * @return detail info
     */
    InterviewDetailDTO custExtDetail(Long id);

    /**
     * 面访客户后上传信息
     * @param param info
     * @return int
     */
    Integer saveInterviewFeedback(InterviewFeedbackParam param) throws BizException;

    /**
     * 取消面访
     * @param interviewId 面访ID
     * @return 操作结果
     */
    Boolean cancelInterview(Long interviewId);

    /**
     * 查询销售小程序二维码
     */
    List<OtoCustomerViewDTO> getInterviewCode(List<Long> ids) throws BizException;

    /**
     * 查询客户授权状态
     */
    OtoCustomerViewDTO getInterviewStatus(OtoCustomerInterviewStatusParam param) throws BizException;

    /**
     * 手机端销售面访列表
     *
     * @param param 参数
     * @return 面访列表
     * @throws BizException 业务异常
     */
    OtoInterviewListDto sellerInterviewList(OtoQueryInterviewRecordParam param);


    /**
     * 获取客户系统中手机号和授权手机号
     */
    OtoCustomerPhoneDTO getInterviewPhone(Long id) throws BizException;
    /**
     * 绑定客户关系
     */
    Boolean interviewBind(Long id) throws BizException;

    /**
     * 绑定客户关系
     */
    Boolean interviewCancel(Long id) throws BizException;

    /**
     * 客户面访评价
     * @param param 评价参数
     * @return 操作结果
     */
    Boolean editEvaluate(InterviewAuthorizeEvaluateParam param) throws BizException;

    /**
     * 查询信息
     * @param id
     * @return
     */
    InterviewEditDetailDTO findInterviewEditDetail(Long id);

    /**
     * 客户绑定微信用户
     * @param param 参数
     * @return 操作结果
     * @throws BizException 用户不一致
     */
    Boolean customerBindWxUser(CustomerBindWxUserParam param) throws BizException;

    /**
     * 授权失败
     * @param param
     * @return
     * @throws BizException
     */
    Boolean authorizeFail(CustomerBindWxUserParam param) ;

    /**
     * 保存地理位置
     * @param otoInterviewStatusParam
     * @return
     * @throws BizException
     */
    boolean saveAddress(OtoCustomerInterviewSaveAddressParam otoInterviewStatusParam);

    /**
     * 查询授权状态
     * @param id 面访ID
     * @param userId 登录用户ID
     */
    OtoCustomerViewDTO getInterviewStatusV1(Long id, Long userId);

    /**
     * 根据小程序码ID查询销售
     */
    OtoSellerDTO getSeller(Long scanCodeId) throws BizException;

    Boolean updateInterviewStatus() ;

    /**
     * 根据面访ID集合批量查询面访信息
     * @param ids
     */
    List<OtoCustomerViewDTO> getByIds(List<Long> ids);


    /**
     * 批量导入面访数据（修数据）
     * @param interviewRecordList 面访数据
     * @return 保存结果
     */
    boolean batchImportInterviewRecord(List<OtoCustInterviewRecordSaveParam> interviewRecordList);

    /**
     * 批量导入面访数据（修数据）
     * @param interviewRecordList 面访数据
     * @return 保存结果
     */
    List<OtoCustInterviewDto> batchImportInterviewRecordReturnIds(List<OtoCustInterviewRecordSaveParam> interviewRecordList);

    /**
     * 根据客户id修改面访类型和面访状态
     * @param ids 客户id
     * @param interviewType 面访类型
     * @param interviewStatus 面访状态
     * @return 修改结果
     */
    boolean modifyInterviewTypeAndStatusByIds(List<Long> ids,Integer interviewType,Integer interviewStatus);

    /**
     * 根据客户id删除面访记录
     * @param id id
     * @return 删除结果
     */
    boolean removeById(Long id);

    /**
     * 根据客户ID查询面访记录
     * @param custId 客户ID
     * @return 面访信息集合
     */
    List<OtoCustomerInterviewListDTO> getOtoCustomerInterviewListByCustId(Long custId);

    /**
     * 根据客户ID和面访状态查询面访记录
     * @param custId 客户ID
     * @param status 面访状态
     * @return 面访记录结果集
     */
    List<OtoCustomerViewDTO> getCustInterviewByCustIdAndStatus(Long custId, Long sellerId, List<Integer> status);

    /**
     * 根据客户ID和面访状态查询面访记录
     * @param custIds 客户ID
     * @param status 面访状态
     * @return 面访记录结果集
     */
    List<OtoCustomerViewDTO> getCustInterviewBySellerIdAndCustIdsAndStatus(List<Long> custIds, Long sellerId, List<Integer> status);

    /**
     * 根据客户ID和面访状态查询面访记录
     * @param custIds 客户ID
     * @param status 面访状态
     * @return 面访记录结果集
     */
    List<OtoCustomerViewDTO> getCustInterviewByExpertIdAndCustIdsAndStatus(List<Long> custIds, Long sellerId, List<Integer> status);

    /**
     * 根据客户ID和面访时间查询面访记录
     * @return 面访记录结果集
     */
    List<OtoCustInterviewDto> getCustInterviewByCustIdAndInterviewTime(List<OtoCustInterviewDto> params);

    /**
     * 根据客户ID查询面访记录
     * @param custId 客户ID
     * @return 面访信息集合
     */
    List<OtoCustInterviewRecordDTO> getCustRecordByCustId(Long custId);

    /**
     * 批量更新面访部分字段数据
     *
     * @param list
     * @return
     */
    boolean batchUpdateInteview(List<OtoCustInterviewDto> list);

    /**
     * 根据客户ID和面访状态查询见面场景配置ID
     *
     * @param custId 客户ID
     * @param status 面访状态
     */
    List<OtoCustomerViewDTO> getInterviewConfIdsByCustIdAndStatus(Long custId, List<Integer> status);

}
