package cn.com.duiba.oto.util;

import com.google.common.collect.Lists;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author xiaotian
 * @version 1.0
 * @date 2022-01-11 17:22
 */
@Data
public class PageResult<T> implements Serializable {

    private static final long serialVersionUID = 5033472050991731743L;

    /**
     * 页码
     */
    private Integer pageIndex;

    /**
     * 查询条数
     */
    private Integer pageSize;

    /**
     * 数据总量
     */
    private Long totalCount;

    /**
     * 数据
     */
    private List<T> list;

    public static <T> PageResult<T> init(Integer pageIndex, Integer pageSize) {
        PageResult<T> pageResult = new PageResult<>();
        pageResult.setList(Lists.newArrayList());
        pageResult.setTotalCount(0L);
        pageResult.setPageIndex(pageIndex);
        pageResult.setPageSize(pageSize);
        return pageResult;
    }
}
