package cn.com.duiba.oto.dto.oto.cust;

import cn.com.duiba.oto.enums.seller.SellerRoleEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 功能描述：
 *
 * @Auther: xiaotian
 * @Date: 2022/10/13 13:55
 * @Description:
 */
@Data
public class OtoCustDto implements Serializable {

    private static final long serialVersionUID = 7630247264568416244L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 销售Id
     */
    private Long sellerId;

    /**
     * 专家id
     */
    private Long expertId;

    private Long inviteId;

    /**
     * 客户名称
     */
    private String custName;

    /**
     * 见面次数
     */
    private Integer meetTimes;

    /**
     * 盘点次数
     */
    private Integer checkTimes;

    /**
     * 是否讲解计划书
     */
    private Integer commitPlanFlag;

    /**
     * 最近盘客户时间
     */
    private String lastCheckTime;

    /**
     * 承接时间
     */
    private String assignTime;

    /**
     * 是否重点跟进
     */
    private Integer custStar;

    /**
     * 最近一次见面时间
     */
    private String lastMeetTime;

    /**
     * 重点跟进人
     *
     * @see SellerRoleEnum
     */
    private Integer followUp;

    /**
     * 见面场景配置ID
     */
    private List<Long> sceneIds;

    /**
     * 促单情况
     */
    private Integer promotionType;

    /**
     * 是否放弃  0否 1是
     */
    private Integer hasGiveUp;

    /**
     * 是否上传kyc
     */
    private Integer isUploadKyc;

    /**
     * 是否上传方案
     */
    private Integer isUploadPlan;
}
