package cn.com.duiba.oto.oto.service.api.remoteservice.cust;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.cust.OtoCustCheckDto;

import java.util.List;

/**
 * @author xiaotian
 * @version 1.0
 * @date 2022-10-11 13:51
 */
@AdvancedFeignClient
public interface RemoteOtoCustCheckService {

    /**
     * 根据客户id查询最近一次盘点记录
     *
     * @param custId 客户id
     * @return 客户信息
     */
    OtoCustCheckDto findLastByCustId(Long custId);

    /**
     * 获取盘点记录
     *
     * @param custIds
     * @return
     */
    List<OtoCustCheckDto> findLastByCustIdList(List<Long> custIds);

    /**
     * 保存盘点记录并返回盘点ID
     */
    OtoCustCheckDto saveRecord(OtoCustCheckDto otoCustCheckDto);

    /**
     * 获取盘点记录
     *
     * @param custId
     * @return
     */
    List<OtoCustCheckDto> findByCustId(Long custId);

    /**
     * 获取盘点记录
     * @param ids 盘点ID
     * @return 结果
     */
    List<OtoCustCheckDto> findByIds(List<Long> ids);
}
