package cn.com.duiba.oto.oto.service.api.remoteservice.cust;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.cust.OtoCustKycSchemeDto;
import cn.com.duiba.oto.param.oto.cust.OtoCustKycSchemeSaveParam;

import java.util.List;


@AdvancedFeignClient
public interface RemoteOtoCustKycSchemeService {

    /**
     * 新增
     * @param param 参数
     * @return 结果
     */
    Boolean save(OtoCustKycSchemeSaveParam param);

    /**
     * 新增
     * @param param 参数
     * @return 结果
     */
    Boolean update(OtoCustKycSchemeSaveParam param);

    /**
     * 根据客户ID查询
     * @param custId 客户ID
     * @return 结果
     */
    List<OtoCustKycSchemeDto> findByCustId(Long custId);

    /**
     * 根据客户ID和上传类型 分页查询
     * @param custId 客户ID
     * @param uploadType 类型
     * @param offset 起始页
     * @param limit 每页数据条数
     * @return 结果
     */
    List<OtoCustKycSchemeDto> findByCustIdAndType(Long custId, Integer uploadType, Integer offset, Integer limit);

    /**
     * 根据客户ID和上传类型 分页查询
     * @param custId 客户ID
     * @param uploadType 类型
     * @return 数量
     */
    Long findCountByCustIdAndType(Long custId, Integer uploadType);
}
