package cn.com.duiba.oto.param.oto.cust;

import cn.com.duiba.oto.param.oto.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author xiaotian
 * @version 1.0
 * @date 2022-10-09 16:55C
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class OtoCustCheckListParam extends PageQuery implements Serializable {

    private static final long serialVersionUID = 6939120829236186248L;

    /**
     * 权限范围内的销售
     */
    private List<Long> allSellerIds;

    /**
     * 销售id
     */
    private List<Long> sellerIds;

    /**
     * 专家id
     */
    private List<Long> expertIds;

    /**
     * 专家id
     */
    private List<Long> inviteIds;

    /**
     * 客户名称
     */
    private String custName;

    /**
     * 见面次数（开始）
     */
    private Integer meetTimesStart;

    /**
     * 见面次数（结束）
     */
    private Integer meetTimesEnd;

    /**
     * 盘点次数（开始）
     */
    private Integer checkTimesStart;

    /**
     * 盘点次数（结束）
     */
    private Integer checkTimesEnd;

    /**
     * 是否讲解计划书 1：是 0 ：否
     */
    private Integer explainPlanFlag;

    /**
     * 是否星标客户 1：是 0 ：否
     */
    private Integer custStar;

    /**
     * 最近一次见面时间（开始）
     */
    private Date lastMeetTimeStart;

    /**
     * 最近一次见面时间（结束）
     */
    private Date lastMeetTimeEnd;

    /**
     * 承接时间（开始）
     */
    private Date continueTimeStart;

    /**
     * 承接时间（结束）
     */
    private Date continueTimeEnd;

    /**
     * 最近盘客户时间（开始）
     */
    private Date checkTimeStart;

    /**
     * 最近盘客户时间（结束）
     */
    private Date checkTimeEnd;

    /**
     * 可查看的销售id
     */
    private List<Long> mustInsellerIds;

    /**
     * 看查看的专家id
     */
    private List<Long> mustInexpertIds;

    /**
     * 重点跟进人
     */
    private List<Integer> followUps;

    /**
     * 客情维护活动参加情况
     */
    private List<Long> safeguardSceneConfIds;

    /**
     * 意向推荐活动参加情况
     */
    private List<Long> recommendSceneConfIds;

    /**
     * 是否可促单 0否 1是
     */
    private Integer promotionTypeFlag;

    /**
     * 是否已盘点  0:未盘点 1:已盘点
     */
    private Integer checkFlag;

    /**
     * 1：今天 2：一周 3：半月 4：一月
     */
    private Integer timeScope;

    /**
     * 是否放弃 0否 1是
     */
    private Integer hasGiveUpFlag;

    /**
     * 标签ID
     */
    private List<Long> tagIds;

    /**
     * 客户id
     */
    private List<Long> custIds;

    /**
     * 直播行为 1：已到场 2：已中奖 3：已填单
     */
    private List<Integer> liveAction;

    /**
     * 参与直播id列表
     */
    private List<String> liveIds;

    /**
            * 是否上传kyc 0否 1是
     */
    private Integer isUploadKyc;

    /**
     * 是否上传方案 0否 1是
     */
    private Integer isUploadPlan;

}
