package cn.com.duiba.oto.dto.oto.product;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 产品表
 *
 * @author kjj mybatis generator
 * @date 2022-03-28
 */
@Data
public class OtoProductDto implements Serializable {

    private static final long serialVersionUID = 16484688807277106L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 产品名称
     */
    private String prodName;

    /**
     * 缴费周期
     */
    private String costOption;

    /**
     * 金额
     */
    private String moneyOption;

    /**
     * 是否上架是否状态 0:否 1:是
     * {@link cn.com.duiba.oto.enums.BooleanEnum}
     */
    private Integer prodStatus;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 产品公司关联
     */
    private List<ProductCompanyRelationDto> companyRelationDtos;

    /** 供应商id，tb_oto_supplier.id */
    private Long supplierId;

    /** 供应商名称 */
    private String supplierName;

    /**
     * 业务类型:{@link cn.com.duiba.oto.enums.OtoProductBusinessTypeEnum}
     */
    private Integer businessType;
}