package cn.com.duiba.oto.dto.oto.cust;

import java.util.Date;
import lombok.Data;
import org.checkerframework.checker.units.qual.Length;

import java.io.Serializable;

/**
 * 客户通话表单记录表
 * @author kjj mybatis generator 
 * @date 2022-01-12
 */
@Data
public class CustCallRecordDto implements Serializable {
     
    private static final long serialVersionUID = 16419780996007343L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 销售id, tb_oto_seller.id
     */
    private Long sellerId;

    /**
     * 客户id, tb_oto_customer.id
     */
    private Long custId;

    /**
     * 通话记录日志id tb_cust_log_id
     */
    private Long callLogId;

    /**
     * 客户价值  1XX代表未接通 2XX中XX代表分数 3XX代表系统高价值
     * @see cn.com.duiba.oto.enums.cust.ext.OtoCustValueEnum
     */
    private Integer custValue;

    /**
     * 核心决策人 0:不明或其他 1:本人或配偶 2:子女 3：父母
     * @see cn.com.duiba.oto.enums.cust.ext.OtoCustCoreMakerEnum
     */
    private Integer coreMaker;

    /**
     * 标签id，用，隔开
     */
    private String tagIds;

    /**
     * 提交方案后客户状态 1近期有机会成交 2近期无法成交 3拒绝
     * @see cn.com.duiba.oto.enums.cust.visit.OtoCustCommitStatusEnum
     */
    private Integer commitCustStatus;

    /**
     * 是否提交养老规划方案 0否 1是
     * @see cn.com.duiba.kjy.base.api.enums.BooleanEnum
     */
    private Integer commitPlanFlag;

    /**
     * 客户备注
     */
    private String custDescription;

    /**
     * 跟进客户权重
     * @see cn.com.duiba.oto.enums.cust.follow.OtoCustFollowWeightEnum
     */
    private Integer followWeight;

    /**
     * 销售评价类型
     * @see cn.com.duiba.oto.enums.OtoCommentTypeEnum
     */
    private Integer commentType;

    /**
     * 评价备注
     * @see cn.com.duiba.oto.enums.log.CustCommonLogKeyEnum
     */
    private String commentRemark;

    /**
     * 居住地址
     */
    private String custAddress;

    /**
     * 客户性别
     * @see cn.com.duiba.oto.enums.cust.CustGenderEnum
     */
    private Integer custGender;

    /**
     * 客户姓名
     */
    private String custName;

    /**
     * 退休金
     * @see cn.com.duiba.oto.enums.cust.ext.OtoCustRetireMoneyEnum
     */
    private Integer retireMoney;

    /**
     * 年龄
     */
    private Integer age;

    /**
     * 通话结束类型
     * @see cn.com.duiba.oto.enums.cust.call.OtoCustomerCallEndTypeEnum
     */
    private Integer callEndType;

    /**
     * 通话结束时间
     */
    private Date callEndTime;

    /**
     * 是否客户以提交表单
     * @see cn.com.duiba.oto.enums.cust.call.OtoCustomerCallSubmittedEnum
     */
    private Integer submitFlag;

    /**
     * 考虑原因
     * @see cn.com.duiba.oto.enums.cust.ext.OtoCustReasonEnum
     */
    private Integer considerReason;

    /**
     * 通话开始时间
     */
    private Date gmtCreate;

    /**
     * 加微信状态
     * @see cn.com.duiba.oto.enums.cust.ext.OtoCustWxStatusEnum
     */
    private Integer addWxStatus;

    /**
     * 为谁考虑养老
     */
    private String considerAgedForWho;

    /**
     * 最关注养老社区什么
     */
    private String attentionOldCommunity;

}