package cn.com.duiba.oto.enums.cust.ext;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-01-11 13:55
 */
@Getter
@AllArgsConstructor
public enum OtoCustVisitProgressEnum {

    NO_INTENTION(0, "无参观意向"),
    INTENTION_NO_VISIT(1, "未参观-有参观意向"),
    ORDER_VISIT(2, "已预约参观时间"),
    VISITED(3, "完成参观");


    /**
     * 参观进度
     */
    private final Integer status;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 包含所有枚举的Map
     */
    private static final Map<Integer, String> ALL_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(OtoCustVisitProgressEnum::getStatus, OtoCustVisitProgressEnum::getDesc, (v1, v2)->v1)));

    /**
     * 根据状态获取描述
     */
    public static String getDescByStatus(Integer status){
        if (status == null) {
            return null;
        }
        return ALL_MAP.get(status);
    }
}
