package cn.com.duiba.oto.oto.service.api.remoteservice.cust;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.seller.HollyCrmAccountDto;

import java.util.List;

/**
 * @author xiaotian
 * @version 1.0
 * @date 2022-01-17 10:19
 */
@AdvancedFeignClient
public interface RemoteHollyCrmAccountService {

    /**
     * 根据销售id获取第三方呼叫平台的账号
     * @param otoSid 销售id
     * @return 第三方呼叫平台的账号
     */
    HollyCrmAccountDto getAccountBySid(Long otoSid);

    /**
     * 新增
     * @param dto 合力亿捷呼叫平台账号
     * @return 执行结果
     */
    boolean insert(HollyCrmAccountDto dto);

    /**
     * 修改合力亿捷呼叫平台账号
     * @param dto 合力亿捷呼叫平台账号
     * @return 操作结果
     */
    boolean update(HollyCrmAccountDto dto);

    /**
     * 根据账号名获取销售id
     * @param loginName 账户名
     * @return 销售id
     */
    Long findSellerByLoginName(String loginName);

    /**
     * 获取所有可用的销售账号
     * @return 所有可用的销售账号
     */
    List<String> listAvailableLoginNames();

    /**
     * 根据销售id获取第三方呼叫平台的账号列表
     * @param sellerIdList 销售id
     * @return 账号列表
     */
    List<HollyCrmAccountDto> listAccountBySids(List<Long> sellerIdList);

    /**
     * 根据销售id删除三方账号
     * @param sellerId 销售id
     * @return 删除结果
     */
    boolean removeAccountBySid(Long sellerId);
}
