package cn.com.duiba.oto.oto.service.api.remoteservice.wxwork;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.OtoH5UserInfoDTO;
import cn.com.duiba.oto.dto.OtoUserDetailInfoDTO;

/**
 * @author liuyajun
 * @date 2022/03/24
 */
@AdvancedFeignClient
public interface RemoteCorpAgentH5LoginService {

    /**
     * 静默授权获取用户信息
     * @param agentid 企微自建应用唯一标识
     * @param code 授权码
     * @return 用户信息
     */
    OtoH5UserInfoDTO getUserInfoByCode(String agentid, String code);

    /**
     * 自建应用读取成员信息
     * @param agentid 企微自建应用唯一标识
     * @param userid
     * @return 用户信息
     */
    OtoUserDetailInfoDTO getUserInfoDetailByUserId(String agentid, String userid);
}
