/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.oto.enums.seller;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SellerRoleEnum {
    SYSTEM(1, 1, "\u7cfb\u7edf\u7ba1\u7406\u5458"),
    DIRECTOR(2, 4, "\u603b\u76d1"),
    OFFICE_STAFF(3, 5, "\u5185\u52e4"),
    EXPERT(4, 6, "\u4e13\u5bb6"),
    INVITE(5, 7, "\u9080\u7ea6"),
    SELLER(6, 8, "\u9500\u552e"),
    AREA_DIRECTOR(7, 2, "\u533a\u57df\u603b"),
    PM(8, 3, "PM"),
    SOLUTION(9, 9, "\u89e3\u51b3\u65b9\u6848");

    private static final Map<Integer, String> TYPE_MAP;
    private Integer code;
    private Integer order;
    private String desc;

    public static String getDescByCode(Integer code) {
        if (code == null) {
            return "";
        }
        return TYPE_MAP.get(code);
    }

    public static SellerRoleEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return Stream.of(SellerRoleEnum.values()).filter(sellerRoleEnum -> sellerRoleEnum.getCode().equals(code)).findFirst().orElse(null);
    }

    public Integer getCode() {
        return this.code;
    }

    public Integer getOrder() {
        return this.order;
    }

    public String getDesc() {
        return this.desc;
    }

    private SellerRoleEnum(Integer code, Integer order, String desc) {
        this.code = code;
        this.order = order;
        this.desc = desc;
    }

    static {
        TYPE_MAP = Collections.unmodifiableMap(Arrays.stream(SellerRoleEnum.values()).collect(Collectors.toMap(SellerRoleEnum::getCode, SellerRoleEnum::getDesc, (v1, v2) -> v1)));
    }
}

