/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.oto.enums.cust.follow;

import cn.com.duiba.kjy.base.api.utils.NumberUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

public enum OtoCustFollowWeightEnum {
    A(1, "A", "\u4e09\u661f"),
    B(2, "B", "\u4e8c\u661f"),
    C(3, "C", "\u4e00\u661f");

    private final Integer type;
    private final String desc;
    private final String starLevel;
    private static final Map<Integer, String> TYPE_MAP;
    private static final Map<Integer, String> STAR_LEVEL_MAP;

    public static String getDescByType(Integer type) {
        if (NumberUtil.isNullOrLteZero((Integer)type)) {
            return null;
        }
        return TYPE_MAP.get(type);
    }

    public static String getStarLevelByType(Integer type) {
        if (NumberUtil.isNullOrLteZero((Integer)type)) {
            return null;
        }
        return STAR_LEVEL_MAP.get(type);
    }

    public static boolean contains(Integer type) {
        if (NumberUtil.isNullOrLteZero((Integer)type)) {
            return false;
        }
        return TYPE_MAP.containsKey(type);
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getStarLevel() {
        return this.starLevel;
    }

    private OtoCustFollowWeightEnum(Integer type, String desc, String starLevel) {
        this.type = type;
        this.desc = desc;
        this.starLevel = starLevel;
    }

    static {
        TYPE_MAP = Collections.unmodifiableMap(Arrays.stream(OtoCustFollowWeightEnum.values()).collect(Collectors.toMap(OtoCustFollowWeightEnum::getType, OtoCustFollowWeightEnum::getDesc)));
        STAR_LEVEL_MAP = Collections.unmodifiableMap(Arrays.stream(OtoCustFollowWeightEnum.values()).collect(Collectors.toMap(OtoCustFollowWeightEnum::getType, OtoCustFollowWeightEnum::getStarLevel)));
    }
}

