package cn.com.duiba.oto.dto.oto.cust;

import cn.com.duiba.oto.enums.OtoCustPlanSourceEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 盘客户-计划执行表
 * @author kjj mybatis generator 
 * @date 2022-11-17
 */
@Data
public class OtoCustPlanDto implements Serializable {
     
    private static final long serialVersionUID = 16686646796552301L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 客户id
     */
    private Long custId;

    /**
     * 计划动作 phone:电话 meet:见面
     */
    private String planActionType;

    /**
     * 计划状态 1计划中 2已完成 3未完成
     */
    private Integer planStatus;

    /**
     * 行动人（销售ID）tb_oto_seller主键ID
     */
    private Long actionSeller;

    /**
     * 行动时间
     */
    private Date actionTime;

    /**
     * 见面场景配置ID tb_interview_scene_conf主键ID
     */
    private Long interviewSceneConfId;

    /**
     * 盘客户表ID tb_oto_cust_check主键ID
     */
    private Long otoCustCheckId;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 计划完成时间
     */
    private Date planFinishTime;

    /**
     * 计划来源
     *
     * @see OtoCustPlanSourceEnum
     */
    private Integer planSource;

    /**
     * 时间段 am上午 pm下午
     */
    private String timeRegion;

    /**
     * 来源：import_id = 导入，normal = 正常入口，quick = 快速盘点
     */
    private String recordFrom = "normal";
}