package cn.com.duiba.oto.dto.oto.wx.wxmessage;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;

/**
 * @author liuyj
 * @date 2022/6/29 18:00
 */
@Data
public class WxWorkAgentMessageDto implements Serializable {
    /**
     * 指定用户id集合，多个使用 | 分割
     */
    @JSONField(name = "touser")
    private String userKeys;

    /**
     * 指定用户部门id，多个使用 | 分割
     */
    @JSONField(name = "toparty")
    private String departmentKeys;

    /**
     * 指定用户标签id，多个使用 | 分割
     */
    @JSONField(name = "totag")
    private String tagKeys;

    /**
     * 应用ID，自建应用使用tb_wxwork_suite表agentKey，
     * 服务商应用请用tb_wxwork_corp_suite企业授权后产生的agentKey
     */
    @JSONField(name = "agentid")
    private String agentKey;

    /**
     * 消息类型
     * @see cn.com.duiba.oto.enums.push.WxAgentMessageTypeEnum
     */
    @JSONField(name = "msgtype")
    private String msgType;

    private TextCardDto textcard;

    private MarkDownDto markdown;
}
