/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.oto.enums.cust.ext;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

public enum OtoCustHouseEnum {
    UN_KNOW(-1, "\u4e0d\u8be6"),
    NO_HOUSE(0, "0"),
    ONE_HOUSE(1, "1"),
    TWO_HOUSE(2, "2"),
    THREE_HOUSE(3, "3\u53ca\u4ee5\u4e0a");

    private final Integer type;
    private final String desc;
    private static final Map<Integer, String> ALL_MAP;

    public static String getDescByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ALL_MAP.get(type);
    }

    public static boolean hasHousePower(Integer hasHouse) {
        return ONE_HOUSE.getType().equals(hasHouse) || TWO_HOUSE.getType().equals(hasHouse) || THREE_HOUSE.getType().equals(hasHouse);
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    private OtoCustHouseEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    static {
        ALL_MAP = Collections.unmodifiableMap(Arrays.stream(OtoCustHouseEnum.values()).collect(Collectors.toMap(OtoCustHouseEnum::getType, OtoCustHouseEnum::getDesc, (v1, v2) -> v1)));
    }
}

