package cn.com.duiba.oto.enums.cust;

import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * OTO 流程组名称
 *
 * @author MeiChang
 * @Description
 */
@Getter
public enum CustBulletinBoardEnum {
    /**
     * 客户经营看板
     */
    WAIT_ASSIGN("follow_customer_link", "当前还在跟进客户数"),
    HAVE_IDEA("invite_customer_link", "邀约来的客户数"),
    AGREE_SOLVE("director_assign_link", "被总监分配的客户数"),
    AGREE_PROJECT("seas_customer_link", "捞取公海的客户数"),
    NOW_TRADING("oneself_customer_link", "自己录入的客户数"),
    HAVE_ORDER("customer_star_link", "星标客户数"),
    ;

    private static final Map<String, CustBulletinBoardEnum> INNER_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(CustBulletinBoardEnum::getCode, Function.identity(), (v1, v2)->v1)));;


    private final String code;
    private final String desc;

    CustBulletinBoardEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static CustBulletinBoardEnum getByCode(String code) {
        return Objects.isNull(code) ? null : INNER_MAP.get(code);
    }

    public static String getDescByCode(String code){
        if (code == null) {
            return null;
        }
        return INNER_MAP.get(code).getDesc();
    }
}
