package cn.com.duiba.oto.oto.service.api.remoteservice.invitation;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.calendar.CustCalendarSearchParam;
import cn.com.duiba.oto.dto.oto.cust.OtoCustInvitationRecordDto;
import cn.com.duiba.oto.dto.oto.invitation.OtoCustInvitationConfigDto;
import cn.com.duiba.oto.param.oto.cust.InvitationSearchForSellerSubmitParam;
import cn.com.duiba.oto.param.oto.cust.OtoCustInvitationRecordSearchParam;

import java.util.List;

/**
 * @author liuyj
 * @date 2022/8/4 09:38
 */
@AdvancedFeignClient
public interface RemoteCustInvitationRecordService {
    /**
     * 根据客户ID和销售ID查询邀约记录详情
     *
     * @param param 查询参数
     */
    List<OtoCustInvitationRecordDto> getDetailByParam(OtoCustInvitationRecordSearchParam param);


    /**
     * 根据主键id查询邀约记录
     *
     * @param ids 查询参数
     */
    List<OtoCustInvitationRecordDto> getDetailByIds(List<Long> ids);

    /**
     * 新增邀约记录信息
     *
     * @param param 参数
     * @return 结果
     */
    boolean save(OtoCustInvitationRecordSearchParam param);

    /**
     * 更新邀约记录信息
     *
     * @param param 参数
     * @return 结果
     */
    boolean update(OtoCustInvitationRecordSearchParam param);

    /**
     * 查询邀约记录是否是最新状态=1&承诺时间<=承诺时间查询条件
     *
     * @param param 查询参数
     */
    List<OtoCustInvitationRecordDto> getListByParam(OtoCustInvitationRecordSearchParam param);

    /**
     * 根据日历参数获取邀约记录
     *
     * @param param 日历参数
     * @return 邀约记录
     */
    List<OtoCustInvitationRecordDto> listByCalendarParam(CustCalendarSearchParam param);

    /**
     * 退回邀约组
     * 校验逻辑：
     * 1.退回邀约组的只能是已分配（预期到场）的客户
     * 核心处理逻辑：
     * <p>
     * 1.当前邀约记录，状态修改为待分配（已鸽），清空带看组和专家
     * 2.当前邀约基础信息，状态修改为待分配（已鸽）
     * 3.客户改派给原邀约人
     * 4.加入邀约组任务中（已退回）
     *
     * @param recordId
     * @return
     */
    boolean assignRollback(Long recordId);


    /**
     * 根据客户id，获取最新的邀约记录
     *
     * @param custIds
     * @return
     */
    List<OtoCustInvitationRecordDto> findLastRecord(List<Long> custIds);

    /**
     * 见面场景改了、（需要就餐改成否、需要接送改成否，接送地址清空）
     *
     * @param custId 主键
     * @return 执行结果
     */
    boolean clearInterviewConfId(Long custId);

    /**
     * 需要接送从否改为是后清空接送时间
     *
     * @param custId 客户id
     * @return 执行结果
     */
    boolean clearpickTakeFlag(Long custId);

    /**
     * 根据邀约记录获取邀请函详情
     *
     * @param custId
     * @param configId
     * @return
     */
    OtoCustInvitationConfigDto invitationConfigDto(Long custId, Long configId);

    /**
     * 根据见面场景ID和状态查询
     */
    List<OtoCustInvitationRecordDto> obtainBySceneIdsAndInviteStatus(List<Long> sceneIds, List<Integer> inviteStatus);


    /**
     * 根据见面场景/时间/客户id，获取所有的邀约记录
     *
     * @param param 查询参数
     */
    List<OtoCustInvitationRecordDto> getRecordForSellerSubmit(InvitationSearchForSellerSubmitParam param);

    /**
     * 批量更新见面场景ID
     * @param sceneConfId
     * @param ids
     * @return
     */
    int updateSceneConfIdByIds(Long sceneConfId, List<Long> ids);

    /**
     * 根据客户ID删除邀约
     * @param customerId 客户ID
     */
    boolean deleteByCustomerId(Long customerId);

}
