package cn.com.duiba.oto.dto.oto.wx.user;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 微信关注用户Bean
 * @author xiaotian
 * @date 2020-06-29 16:09
 **/
@Data
public class WxSubscriberUserBean implements Serializable {

    private static final long serialVersionUID = -3810819908518208323L;

    /**
     * 是否关注 1:关注 0:未关注
     */
    private int subscribe;
    /**
     * 加密的微信id
     */
    private String openid;
    /**
     * 微信昵称
     */
    private String nickname;
    /**
     * 1:男 2:女 0:未知
     */
    private int sex;
    /**
     * 用户的语言，简体中文为zh_CN
     */
    private String language;
    /**
     * 所在城市
     */
    private String city;
    /**
     * 所在省
     *
     */
    private String province;
    /**
     * 所在国家
     */
    private String country;
    /**
     * 微信头像地址
     */
    private String headimgurl;
    /**
     * 用户关注时间
     */
    private long subscribe_time;
    /**
     * 只有在用户将公众号绑定到微信开放平台帐号后，才会出现该字段
     */
    private String unionid;
    /**
     * 公众号运营者对粉丝的备注
     */
    private String remark;
    /**
     * 用户所在的分组ID
     */
    private int groupid;
    /**
     * 用户被打上的标签ID列表
     */
    private List<String> tagid_list;
    /**
     * 返回用户关注的渠道来源，ADD_SCENE_SEARCH 公众号搜索，ADD_SCENE_ACCOUNT_MIGRATION 公众号迁移，ADD_SCENE_PROFILE_CARD 名片分享，ADD_SCENE_QR_CODE 扫描二维码，ADD_SCENE_PROFILE_LINK 图文页内名称点击，ADD_SCENE_PROFILE_ITEM 图文页右上角菜单，ADD_SCENE_PAID 支付后关注，ADD_SCENE_WECHAT_ADVERTISEMENT 微信广告，ADD_SCENE_OTHERS 其他
     */
    private String subscribe_scene;
    /**
     * 二维码扫码场景
     */
    private long qr_scene;
    /**
     * 二维码扫码场景描述
     */
    private String qr_scene_str;
}
