package cn.com.duiba.oto.enums.form.customer;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 公域引流-用户管理分发情况枚举
 *
 * @author xiaocong
 * @date 2021/11/15 5:10 下午
 */
@AllArgsConstructor
@Getter
public enum PubFormCustomerDistributeStatusEnum {

    /**
     * 等待电联
     */
    WAIT_CONNECT(1, "等待电联"),

    /**
     * 等待分发
     */
    WAIT_DISTRIBUTE(2, "等待分发"),

    /**
     * 等待面访
     */
    WAIT_MEET(3, "等待面访"),

    /**
     * 结束
     */
    FINISH(4, "结束");


    /**
     * code码
     */
    private final Integer code;

    /**
     * 描述
     */
    private final String desc;

    public static final Map<Integer, String> STATUS_MAP;

    static {
        Map<Integer, String> map = Arrays.stream(values()).collect(Collectors.toMap(PubFormCustomerDistributeStatusEnum::getCode, PubFormCustomerDistributeStatusEnum::getDesc));
        STATUS_MAP = Collections.unmodifiableMap(map);
    }
}
