package cn.com.duiba.oto.oto.service.api.remoteservice.bulletinboard;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.bean.bulletinboard.BulletinboardInterviewRecordBean;
import cn.com.duiba.oto.bean.bulletinboard.BulletinboardPlanRecordBean;
import cn.com.duiba.oto.bean.bulletinboard.BulletinboardRecordBean;
import cn.com.duiba.oto.param.oto.bulletinboard.RecordSearchParam;

import java.util.List;

/**
 * @author xiaotian
 * @version 1.0
 * @date 2022-07-20 17:11
 */
@AdvancedFeignClient
public interface RemoteBulletinBoardService {

    /**
     * 筛选客户面访数据
     * @param param
     * @return
     */
   List<BulletinboardInterviewRecordBean> searchInterviewList(RecordSearchParam param);

    /**
     * 筛选客户电话数据
     * @param param
     * @return
     */
    List<BulletinboardRecordBean> searchCallLogList(RecordSearchParam param);


    /**
     * 筛选客户微信聊天数据
     * @param param
     * @return
     */
    List<BulletinboardRecordBean> searchWxMsgList(RecordSearchParam param);


    /**
     * 筛选客户微信好友数据
     * @param param
     * @return
     */
    List<BulletinboardRecordBean> searchWxFriendList(RecordSearchParam param);


    /**
     * 筛选客户计划数据
     * @param param
     * @return
     */
    List<BulletinboardPlanRecordBean> searchPlanList(RecordSearchParam param);


    /**
     * 筛选客户kyc数据
     * @param param
     * @return
     */
    List<BulletinboardRecordBean> searchKycList(RecordSearchParam param);
}
