package cn.com.duiba.oto.oto.service.api.remoteservice.wx.tag;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.wx.BaseResponse;
import cn.com.duiba.oto.dto.oto.wx.tag.GetTagUserListResponse;
import cn.com.duiba.oto.param.oto.wx.tag.BatchTaggingParam;
import cn.com.duiba.oto.param.oto.wx.tag.BatchUnTaggingParam;
import cn.com.duiba.oto.param.oto.wx.tag.TagUserListParam;

/**
 * 微信用户标签管理
 * @author lizhi
 * @date 2020/9/29 2:17 PM
 */
@AdvancedFeignClient
public interface RemoteWxUserTagService {

    /**
     * 获取标签下粉丝列表
     * @param param 获取标签下粉丝列表参数
     * @return 是否成功
     */
    GetTagUserListResponse getTagUserList(TagUserListParam param);

    /**
     * 批量为用户打标签
     * @param param 参数
     * @return 标签ID
     */
    BaseResponse batchTagging(BatchTaggingParam param);

    /**
     * 批量为用户取消标签
     * @param param 参数
     * @return 是否成功
     */
    BaseResponse batchUnTagging(BatchUnTaggingParam param);
}
