package cn.com.duiba.oto.param.oto;

import cn.com.duiba.oto.enums.seller.SellerRoleEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * OTO-销售信息
 *
 * @author ZhangJun
 * @date 2022/1/7 5:16 下午
 */
@Data
public class OtoSellerDto implements Serializable {

    private static final long serialVersionUID = -6283587838740023380L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 销售手机号
     */
    private String phoneNumber;

    /**
     * 销售姓名
     */
    private String sellerName;

    /**
     * 工作台使用权限,0-禁用,1-启用
     * {@link cn.com.duiba.oto.enums.OtoSellerStatusEnum}
     */
    private Integer sellerStatus;

    /**
     * 呼叫权限,0-禁用,1-启用
     * {@link cn.com.duiba.oto.enums.OtoSellerCallPermissionEnum}
     */
    private Integer callPermission;

    /**
     * 认领新客户&强制分配权限 0禁用 1启用
     * {@link cn.com.duiba.oto.enums.OtoSellerPermissionEnum}
     */
    private Integer assignNewCustPermission;

    /**
     * 认领回收客户权限 0禁用 1启用
     * {@link cn.com.duiba.oto.enums.OtoSellerPermissionEnum}
     */
    private Integer assignRecycleCustPermission;

    /**
     * 查看客户微信权限 0禁用 1启用
     * {@link cn.com.duiba.oto.enums.OtoSellerPermissionEnum}
     */
    private Integer lookCustPhonePermission;

    /**
     * 角色类型,1-普通销售,2-销售管理员
     * @see SellerRoleEnum
     */
    private Integer roleType;

    private String roleName;

    /**
     * 所属销售总监id
     */
    private Long parentId;

    /**
     * 销售总监姓名
     */
    private String sellerDirectorName;

    /**
     * 销售等级,1=A,2=B,3=C
     *
     * @see cn.com.duiba.oto.enums.OtoSellerLevelEnum
     */
    private Integer sellerLevel;

    /**
     * 所属公司id
     * tb_oto_company.id
     */
    private Long sellerCompany;


    /**
     * 所属公司名称
     */
    private String sellerCompanyName;

    /**
     * 工作状态,0-非工作中,1=工作中
     * @see cn.com.duiba.oto.enums.OtoSellerWorkStatusEnum
     */
    private Integer workStatus;

    /**
     * 离职状态，0-未离职，1-已离职
     * @see cn.com.duiba.oto.enums.OtoSellerDimissionStatusEnum
     */
    private Integer dimissionStatus;

    /**
     * 销售所在地区
     */
    private String sellerArea;

    /**
     * 最后登录时间
     */
    private Date lastLoginTime;

    /**
     * 创建时间
     */
    private Date gmtCreate;
    /**
     * 销售类型
     */
    private String sellerType;
    /**
     * tb_oto_user.id
     */
    private Long otoUserId;

    /**
     * 客户总系数
     */
    private Integer totalCoefficient;

    /**
     * tb_user.id
     */
    private Long userId;

    /**
     * 使用第三方类型 1:合力忆捷 2:云客，用‘,’分开'
     *
     * @see cn.com.duiba.oto.enums.cust.call.OtoCustomerCallThirdPartyEnum
     */
    private String thirdParty;
}
