package cn.com.duiba.oto.oto.service.api.remoteservice.market;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.cust.OtoMarketDeptDto;
import cn.com.duiba.oto.param.oto.cust.OtoMarketDeptSaveParam;

import java.util.List;


@AdvancedFeignClient
public interface RemoteOtoMarketDeptService {

    /**
     * 批量新增营销活动关联团队和数量
     * @param params 参数
     * @return
     */
    boolean batchSave(List<OtoMarketDeptSaveParam> params);

    /**
     * 批量修改营销活动关联团队和数量
     * @param params 参数
     * @return
     */
    boolean batchUpdate(List<OtoMarketDeptSaveParam> params);

    /**
     * 根据场次ID删除
     * @param marketId 场次ID
     * @return 结果
     */
    Integer updateByMarketId(Long marketId);

    /**
     * 根据ID批量查询
     * @param marketIds 业务ID集合
     * @return 结果
     */
    List<OtoMarketDeptDto> selectByIds(List<Long> marketIds);

}
