package cn.com.duiba.oto.oto.service.api.remoteservice.supplier;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.supplier.SupplierListDTO;
import cn.com.duiba.oto.dto.oto.supplier.SupplierSimpleDTO;
import cn.com.duiba.oto.param.oto.supplier.SupplierSaveParam;
import cn.com.duiba.oto.param.oto.supplier.SupplierSearchParam;
import cn.com.duiba.oto.param.oto.supplier.SupplierUpdateParam;
import cn.com.duiba.oto.util.PageResult;

import java.util.List;

/**
 * 描述：
 *
 * @author zhouziwu
 * @date 2022-05-26
 */
@AdvancedFeignClient
public interface RemoteOtoSupplierService {

    /**
     * 供应商分页查询
     * @param param 查询条件
     * @return 供应商详情
     */
    PageResult<SupplierListDTO> list(SupplierSearchParam param);

    /**
     * 供应商新增
     * @param param 供应商信息
     * @return 新增结果
     */
    Boolean save(SupplierSaveParam param);

    /**
     * 供应商编辑更新
     * @param param 更新的信息
     * @return 更新结果
     */
    Boolean update(SupplierUpdateParam param);

    /**
     * 查询所有供应商,管理后台使用
     * @return 所有供应商信息
     */
    List<SupplierSimpleDTO> listAll();
}
