package cn.com.duiba.oto.param.oto.cust;

import cn.com.duiba.oto.param.oto.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author xiaotian
 * @version 1.0
 * @date 2022-10-09 16:55C
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class OtoCustCheckListParam extends PageQuery implements Serializable {

    private static final long serialVersionUID = 6939120829236186248L;

    /**
     * 权限范围内的销售
     */
    private List<Long> allSellerIds;

    /**
     * 销售id
     */
    private List<Long> sellerIds;

    /**
     * 专家id
     */
    private List<Long> expertIds;

    /**
     * 专家id
     */
    private List<Long> inviteIds;

    /**
     * 客户名称
     */
    private String custName;

    /**
     * 见面次数（开始）
     */
    private Integer meetTimesStart;

    /**
     * 见面次数（结束）
     */
    private Integer meetTimesEnd;

    /**
     * 盘点次数（开始）
     */
    private Integer checkTimesStart;

    /**
     * 盘点次数（结束）
     */
    private Integer checkTimesEnd;

    /**
     * 是否讲解计划书 1：是 0 ：否
     */
    private Integer explainPlanFlag;

    /**
     * 是否星标客户 1：是 0 ：否
     */
    private Integer custStar;

    /**
     * 最近一次见面时间（开始）
     */
    private Date lastMeetTimeStart;

    /**
     * 最近一次见面时间（结束）
     */
    private Date lastMeetTimeEnd;

    /**
     * 承接时间（开始）
     */
    private Date continueTimeStart;

    /**
     * 承接时间（结束）
     */
    private Date continueTimeEnd;

    /**
     * 最近盘客户时间（开始）
     */
    private Date checkTimeStart;

    /**
     * 最近盘客户时间（结束）
     */
    private Date checkTimeEnd;

    /**
     * 今日是否已盘点 1：已盘点 0；未盘点
     */
    private Integer todayCheck;

    /**
     * 可查看的销售id
     */
    private List<Long> mustInsellerIds;

    /**
     * 看查看的专家id
     */
    private List<Long> mustInexpertIds;

    /**
     * 重点跟进人
     */
    private List<Integer> followUps;

}
