package cn.com.duiba.oto.oto.service.api.remoteservice.wx;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.bean.wx.MpQrcodeBean;
import cn.com.duiba.oto.dto.oto.wx.material.DownloadFileBean;

/**
 * <p>生成公众号带参数二维码<br/>
 * 临时二维码： 二维码只能在有效期内使用。有效期：自生成时开始的30天内。<br/>
 * 永久二维码： 永久有效。但单个公众号最多只能生成10万个(暂不开放)<br/>
 * 整型：二维码附加参数为整型。 注意：在notify接口进行妥善处理。<br/>
 * 字符串类型：二维码附加参数为字符串。 注意：在notify接口进行妥善处理。<br/>
 * 详情： https://developers.weixin.qq.com/doc/offiaccount/Account_Management/Generating_a_Parametric_QR_Code.html
 * </p>
 *
 * @author xiaotian
 * @date 2020/11/16 3:05 下午
 */
@AdvancedFeignClient
public interface RemoteWechatMpQrcodeService {

    /**
     * 获取小程序二维码，并上传到oss存储
     * Params:
     * oaId – oaId,tb_official_accounts.id
     * objectName – 上传到OSS的路径
     * mpQrcodeParam – 二维码配置
     * Returns:
     * 获取二维码结果
     */
    DownloadFileBean getWxCodeUnLimit(Long oaId, String objectName, MpQrcodeBean mpQrcodeParam);
}
