package cn.com.duiba.oto.dto.oto.serviceCard;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 功能描述：
 *
 * @Auther: xiaotian
 * @Date: 2023/9/6 13:59
 * @Description:
 */
@Data
public class ServiceCardDto implements Serializable {
    private static final long serialVersionUID = 1578142031834111747L;

    private Long id;

    /**
     * 客户id
     */
    private Long custId;

    /**
     * 实体卡片id
     */
    private String cardNum;

    /**
     * 卡片状态：0:未激活 1:已激活
     *
     ( @see cn.com.duiba.oto.enums.serviceCard.ActiveStateEnum
     */
    private Integer cardStatus;

    /**
     * 卡片状态 0:不可见 1:可见
     * @see cn.com.duiba.oto.enums.serviceCard.CardStateEnum
     */
    private Integer cardState;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 最后修改时间
     */
    private Date gmtModified;

    /**
     * 来源 1:管理后台录入 2:微信在线下单
     * @see cn.com.duiba.oto.enums.serviceCard.FromSourceEnum
     */
    private Integer fromSource;
    /**
     * 原金额
     */
    private Long totalAmount;
    /**
     * 优惠金额
     */
    private Long discountsAmount;
    /**
     * 实付金额
     */
    private Long payAmount;
    /**
     * 支付时间
     */
    private Date payTime;

    /**
     * 购买类型 1：客户自购 2：购保增卡
     */
    private Integer buyType = 1;
}
