package cn.com.duiba.oto.enums;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author xiaotian
 * @date 2020/5/18 4:21 PM
 */
public enum BooleanEnum {

    TRUE(1, "是"),
    FALSE(0, "否"),
    ;

    private Integer code;

    private String desc;

    BooleanEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 包含所有枚举的Map
     */
    private static final Map<Integer, String> ALL_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(BooleanEnum::getCode, BooleanEnum::getDesc, (v1, v2) -> v1)));

    /**
     * 根据类型获取描述
     */
    public static String getDescCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ALL_MAP.get(code);
    }
}
