package cn.com.duiba.oto.oto.service.api.remoteservice.wx;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.wx.BaseResponse;
import cn.com.duiba.oto.dto.oto.wx.menu.ConditionalTryMatchResponse;
import cn.com.duiba.oto.dto.oto.wx.menu.CreateConditionalMenuResponse;
import cn.com.duiba.oto.dto.oto.wx.menu.GetAllMenuResponse;
import cn.com.duiba.oto.param.oto.wx.WxBaseParam;
import cn.com.duiba.oto.param.oto.wx.menu.ConditionalTryMatchParam;
import cn.com.duiba.oto.param.oto.wx.menu.CreateConditionalMenuParam;
import cn.com.duiba.oto.param.oto.wx.menu.CreateDefaultMenuParam;
import cn.com.duiba.oto.param.oto.wx.menu.DeleteConditionalMenuParam;


/**
 * 公众号菜单管理
 *
 * @author xiaotian
 * @date 2020/10/9 11:16 AM
 */
@AdvancedFeignClient
public interface RemoteWxMenuService {

    /**
     * 创建默认菜单
     * @param param 创建默认菜单参数
     * @return 是否成功
     */
    BaseResponse createDefaultMenu(CreateDefaultMenuParam param);

    /**
     * 创建个性化菜单
     * @param param 创建个性化菜单参数
     * @return 菜单ID
     */
    CreateConditionalMenuResponse createConditionalMenu(CreateConditionalMenuParam param);

    /**
     * 删除个性化菜单
     * @param param 删除个性化菜单参数
     * @return 是否成功
     */
    BaseResponse deleteConditionalMenu(DeleteConditionalMenuParam param);

    /**
     * 获取公众号所有菜单
     * @param param 公众号ID
     * @return 菜单
     */
    GetAllMenuResponse getAllMenu(WxBaseParam param);

    /**
     * 测试个性化菜单匹配结果
     * @param param 用户openId
     * @return 用户当前菜单
     */
    ConditionalTryMatchResponse conditionalTryMatch(ConditionalTryMatchParam param);
}
