package cn.com.duiba.oto.enums.cust;

import com.google.common.collect.ImmutableMap;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 盘点客户分类枚举
 * @author xiaotian
 */
@Getter
@AllArgsConstructor
public enum CheckCustTypeEnum {

    /**
     * 客户分类 1：未见面 2：已初次见面 3：已上传kyc 4：已上传风险评估报告 5：已上传方案 6：促单客户 7:已讲解方案客户
     */

    NEVER_MEET("未见面客户", 1,6,true),
    MEET("已初次见面客户", 2,5,true),
    KYC("已上传kyc客户", 3,4,true),
    EVALUATE("已出风险评估报告", 4,3,true),
    PLAN("已出解决方案", 5,2,true),
    PROMOTION("促单客户", 6,1,true),
    PLAN_EXPLAIN("已讲解方案客户", 7,7,false);

    private final String desc;
    private final Integer code;
    private final Integer order;
    private final boolean show;
    private static final ImmutableMap<Integer, CheckCustTypeEnum> INNER_MAP;
    static {
        ImmutableMap.Builder<Integer, CheckCustTypeEnum> builder = ImmutableMap.builder();
        for (CheckCustTypeEnum item : CheckCustTypeEnum.values()) {
            builder = builder.put(item.code, item);
        }
        INNER_MAP = builder.build();
    }

    public static CheckCustTypeEnum getByCode(Integer code) {
        return INNER_MAP.get(code);
    }
}
