package cn.com.duiba.oto.oto.service.api.remoteservice.wx;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.wx.material.PerpetualNewsImageResultDto;
import cn.com.duiba.oto.dto.oto.wx.material.PerpetualNewsResultDto;
import cn.com.duiba.oto.dto.oto.wx.material.PerpetualResultDto;
import cn.com.duiba.oto.dto.oto.wx.material.TemporaryResultDto;
import cn.com.duiba.oto.param.oto.wx.material.PerpetualMaterialParam;
import cn.com.duiba.oto.param.oto.wx.material.TemporaryMaterialParam;

/**
 * Created by xiaotian on 2020-03-13.
 */
@AdvancedFeignClient
public interface RemoteUploadMaterialService {

    /**
     * 上传临时素材
     */
    TemporaryResultDto uploadTemporaryMaterials(TemporaryMaterialParam temporaryMaterialParam);

    /**
     * 上传永久素材
     */
    PerpetualResultDto uploadPerpetualMaterials(PerpetualMaterialParam perpetualMaterialParam);


    /**
     * 上传图文消息内的图片获取URL
     * @param url
     * @param oaId 公众号的Id
     * @param fileName 文件名称
     * @return 上传结果
     */
    PerpetualNewsImageResultDto uploadPerpetualMaterialForNews(String url, Long oaId, String fileName);

    /**
     * 新增永久图文素材
     * @param oaId
     * @param title
     * @param content
     * @return
     */
    PerpetualNewsResultDto uploadMaterialNews(Long oaId, String title, String content);


    /**
     * 删除永久素材
     * @param oaId
     * @return
     */
    boolean deletePerpetualMaterial(Long oaId,String mediaId);
}
