package cn.com.duiba.oto.dto.oto.wx.wxmessage.innerlog;

import lombok.Data;

import java.io.Serializable;
import java.util.Map;

/**
 * 推送埋点参数
 *
 * @author xiaotian
 * @date 2019/7/18 4:32 PM
 */
@Data
public class WxSendEmbedDto implements Serializable {

    private static final long serialVersionUID = -3905204238060180014L;

    /**
     * 推送事件类型
     */
    private String pushEventType;

    /**
     * 推送成功埋点定制参数，没有就不用赋值，key以下划线分隔，不要用驼峰
     */
    private Map<String, Object> customMap;//NOSONAR

    /**
     * 单条推送的唯一标记，无需填写，自动生成
     */
    private String mark;

    public WxSendEmbedDto(String pushEventType) {
        this.pushEventType = pushEventType;
    }

    public WxSendEmbedDto(String pushEventType, Map<String, Object> customMap) {
        this.pushEventType = pushEventType;
        this.customMap = customMap;
    }
}
