package cn.com.duiba.oto.enums.pay;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang.StringUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * 支付渠道枚举
 *
 * @author xiaotian
 * @date 2020/2/28 11:42 AM
 */
@Getter
@AllArgsConstructor
public enum ChannelTypeEnum {

    /**
     * 微信小程序支付
     */
    WX_LITE("wx_lite", "微信小程序支付", PayTypeEnum.WX_PAY.getType()),

    /**
     * 支付宝小程序支付
     */
    ALIPAY_LITE("alipay_lite", "支付宝小程序支付", PayTypeEnum.ALIPAY.getType()),
    ;

    private static final Map<String, ChannelTypeEnum> ENUM_MAP = new HashMap<>();

    static {
        for (ChannelTypeEnum typeEnum : values()) {
            ENUM_MAP.put(typeEnum.getChannelType(), typeEnum);
        }
    }

    private final String channelType;
    private final String channelName;
    private final Integer payType;

    public static ChannelTypeEnum getByChannelType(String channelType) {
        if (channelType == null) {
            return null;
        }
        return ENUM_MAP.get(channelType);
    }

    /**
     * 返回channelType是否有效
     *
     * @param channelType 渠道
     * @return 是否有效
     */
    public static boolean isActive(String channelType) {
        if (StringUtils.isBlank(channelType)) {
            return false;
        }
        return getByChannelType(channelType) != null;
    }
}
