package cn.com.duiba.oto.enums.pay.alipay;

import lombok.Getter;

/**
 * 支付宝交易状态枚举
 *
 * @author 吴文哲
 * @date 2020-07-09 13:48
 **/
@Getter
public enum AlipayTradeStatusEnums {

    WAIT_BUYER_PAY("WAIT_BUYER_PAY", "交易创建"),
    TRADE_CLOSED("TRADE_CLOSED", "未付款交易超时关闭，或支付完成后全额退款"),
    TRADE_SUCCESS("TRADE_SUCCESS", "交易支付成功"),
    TRADE_FINISHED("TRADE_FINISHED", "交易结束，不可退款"),

    ;

    /**
     * 交易状态
     */
    private String tradeStatus;

    /**
     * 描述
     */
    private String desc;


    AlipayTradeStatusEnums(String tradeStatus, String desc) {
        this.tradeStatus = tradeStatus;
        this.desc = desc;
    }

}
