/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.oto.enums.cust;

import cn.com.duiba.oto.enums.cust.CustActionTypeEnum;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public enum CustFromSourceEnum {
    PUB_SELF_BUILD_FORM("01_01", CustActionTypeEnum.FORM, "\u6295\u653e\u5ba2\u6237-\u81ea\u5efa\u843d\u5730\u9875-\u8868\u5355"),
    PUB_SELF_BUILD_LIVE("01_01", CustActionTypeEnum.LAUNCH_LIVE, "\u6295\u653e\u5ba2\u6237-\u81ea\u5efa\u843d\u5730\u9875-\u76f4\u64ad"),
    PUB_FEIYU_CLUE_INVALID("01_02", CustActionTypeEnum.INVALID, "\u6295\u653e\u5ba2\u6237-\u98de\u9c7c\u843d\u5730\u9875-\u672a\u77e5\u884c\u4e3a"),
    PUB_FEIYU_CLUE_FORM("01_02", CustActionTypeEnum.FORM, "\u6295\u653e\u5ba2\u6237-\u98de\u9c7c\u843d\u5730\u9875-\u586b\u5355\u5ba2\u6237"),
    PUB_FEIYU_CLUE_CONSULT("01_02", CustActionTypeEnum.CONSULT, "\u6295\u653e\u5ba2\u6237-\u98de\u9c7c\u843d\u5730\u9875-\u54a8\u8be2\u83b7\u5ba2"),
    PUB_TENCENT_CLUE_INVALID("01_03", CustActionTypeEnum.INVALID, "\u6295\u653e\u5ba2\u6237-\u817e\u8baf\u843d\u5730\u9875-\u672a\u77e5\u884c\u4e3a"),
    PUB_TENCENT_CLUE_FORM("01_03", CustActionTypeEnum.FORM, "\u6295\u653e\u5ba2\u6237-\u817e\u8baf\u843d\u5730\u9875-\u586b\u5355\u5ba2\u6237"),
    PUB_TENCENT_CLUE_CONSULT("01_03", CustActionTypeEnum.CONSULT, "\u6295\u653e\u5ba2\u6237-\u817e\u8baf\u843d\u5730\u9875-\u54a8\u8be2\u83b7\u5ba2"),
    PUB_TENCENT_CLUE_PHONE("01_03", CustActionTypeEnum.INTELLIGENT_PHONE, "\u6295\u653e\u5ba2\u6237-\u817e\u8baf\u843d\u5730\u9875-\u667a\u80fd\u7535\u8bdd"),
    PUB_TENCENT_CLUE_WX_PAY_VIP("01_03", CustActionTypeEnum.WX_PAY_VIP, "\u6295\u653e\u5ba2\u6237-\u817e\u8baf\u843d\u5730\u9875-\u586b\u5355\u5ba2\u6237\uff08\u4f1a\u5458\u5927\u793c\u5305\uff09"),
    PUB_BAIDU_CLUE_INVALID("01_04", CustActionTypeEnum.INVALID, "\u6295\u653e\u5ba2\u6237-\u767e\u5ea6\u843d\u5730\u9875-\u672a\u77e5\u884c\u4e3a"),
    PUB_BAIDU_CLUE_FORM("01_04", CustActionTypeEnum.FORM, "\u6295\u653e\u5ba2\u6237-\u767e\u5ea6\u843d\u5730\u9875-\u586b\u5355\u5ba2\u6237"),
    PUB_HISTORY_IMPORT_FORM("01_05", CustActionTypeEnum.FORM, "\u6295\u653e\u5ba2\u6237-\u5386\u53f2\u8868\u5355\u5bfc\u5165-\u586b\u5355\u5ba2\u6237"),
    PUB_OFFICE_WEBSITE_IMPORT_FORM("01_06", CustActionTypeEnum.FORM, "\u6295\u653e\u5ba2\u6237-\u5b98\u7f51-\u8868\u5355\u54a8\u8be2"),
    SELLER_OLD_CUST("02_01", CustActionTypeEnum.OLD, "\u9500\u552e\u81ea\u5efa-\u7f18\u6545\u5ba2\u6237-\u7f18\u6545\u5ba2\u6237"),
    SELLER_INTRODUCE_CUST("02_02", CustActionTypeEnum.INTRODUCE, "\u9500\u552e\u81ea\u5efa-\u8f6c\u4ecb\u7ecd\u5ba2\u6237-\u8f6c\u4ecb\u7ecd\u5ba2\u6237"),
    SELLER_INTRODUCE_CUST_FOR_CHECK("02_03", CustActionTypeEnum.INTRODUCE, "\u9500\u552e\u81ea\u5efa-\u8f6c\u4ecb\u7ecd\u5ba2\u6237-\u76d8\u70b9\u5ba2\u6237\u65b0\u589e"),
    OTHER_ONLINE_MARKET_LIVE("03_01", CustActionTypeEnum.LIVE_FISSION, "\u5176\u4ed6\u6765\u6e90-\u7ebf\u4e0a\u8425\u9500\u88c2\u53d8-\u76f4\u64ad\u88c2\u53d8"),
    OTHER_ONLINE_MARKET_ASSIST("03_01", CustActionTypeEnum.ASSIST, "\u5176\u4ed6\u6765\u6e90-\u7ebf\u4e0a\u8425\u9500\u88c2\u53d8-\u52a9\u624b\u5ba2\u6237"),
    OTHER_ONLINE_MARKET_CORP_WX("03_01", CustActionTypeEnum.CORP_WX, "\u5176\u4ed6\u6765\u6e90-\u7ebf\u4e0a\u8425\u9500\u88c2\u53d8-\u4f01\u5fae"),
    OTHER_ONLINE_MARKET_LIVE_INTRODUCE("03_01", CustActionTypeEnum.LIVE_INTRODUCE, "\u5176\u4ed6\u6765\u6e90-\u7ebf\u4e0a\u8425\u9500\u88c2\u53d8-\u76f4\u64ad\u8f6c\u4ecb\u7ecd"),
    OTHER_ONLINE_MARKET_OA("03_01", CustActionTypeEnum.OA, "\u5176\u4ed6\u6765\u6e90-\u7ebf\u4e0a\u8425\u9500\u88c2\u53d8-\u516c\u4f17\u53f7"),
    OTHER_ONLINE_WX_PAY("03_01", CustActionTypeEnum.WX_PAY, "\u5176\u4ed6\u6765\u6e90-\u7ebf\u4e0a\u8425\u9500\u88c2\u53d8-\u652f\u4ed8"),
    OTHER_ONLINE_FISSION("03_01", CustActionTypeEnum.FISSION, "\u5176\u4ed6\u6765\u6e90-\u7ebf\u4e0a\u8425\u9500\u88c2\u53d8-\u65b0\u5e74\u88c2\u53d8\u6d3b\u52a8"),
    OTHER_ONLINE_ACTIVITY_1("03_01", CustActionTypeEnum.ACTIVITY_1, "\u5176\u4ed6\u6765\u6e90-\u7ebf\u4e0a\u8425\u9500\u88c2\u53d8-\u6d4b\u8bc4\u88c2\u53d8\u6d3b\u52a8"),
    OTHER_ONLINE_LIVE("03_01", CustActionTypeEnum.LIVE, "\u5176\u4ed6\u6765\u6e90-\u7ebf\u4e0a\u8425\u9500\u88c2\u53d8-\u76f4\u64ad"),
    OTHER_ONLINE_BUY("03_01", CustActionTypeEnum.BUY, "\u5176\u4ed6\u6765\u6e90-\u7ebf\u4e0a\u8425\u9500\u88c2\u53d8-\u56e2\u8d2d"),
    OTHER_OFFLINE_COMMUNITY("03_02", CustActionTypeEnum.COMMUNITY, "\u5176\u4ed6\u6765\u6e90-\u7ebf\u4e0b\u6765\u6e90-\u7ebf\u4e0b\u793e\u533a"),
    OTHER_OFFLINE_TAIBAO("03_02", CustActionTypeEnum.TAIBAO, "\u5176\u4ed6\u6765\u6e90-\u7ebf\u4e0b\u6765\u6e90-\u592a\u4fdd\u5408\u4f5c"),
    OTHER_OFFLINE_INVITE_INTRODUCE("03_02", CustActionTypeEnum.INVITE_INTRODUCE, "\u5176\u4ed6\u6765\u6e90-\u7ebf\u4e0b\u6765\u6e90-\u9080\u7ea6\u8f6c\u4ecb\u7ecd\u5ba2\u6237"),
    OTHER_OFFLINE_COMMUNITY_INTRODUCE("03_02", CustActionTypeEnum.COMMUNITY_INTRODUCE, "\u5176\u4ed6\u6765\u6e90-\u7ebf\u4e0b\u6765\u6e90-\u793e\u533a\u8f6c\u4ecb\u7ecd\u5ba2\u6237"),
    OTHER_OFFLINE_VIDEO("03_03", CustActionTypeEnum.VIDEO, "\u5176\u4ed6\u6765\u6e90-\u89c6\u9891\u53f7-\u54a8\u8be2\u5ba2\u6237");

    private final String fromSource;
    private final CustActionTypeEnum actionType;
    private final String desc;
    private static Map<String, Map<String, CustFromSourceEnum>> SOURCE_MAP;
    private static final Set<String> CLUE_SOURCE_SET;
    private static final Set<String> SELLER_SOURCE_SET;
    private static final Set<String> SELLER_SOURCE_CHECK_PHONE_SET;
    public static final List<String> INTRODUCE_SOURCE_LIST;
    public static final List<String> INTRODUCE_OR_OLD_SOURCE_LIST;

    public static String getStringByEnum(CustFromSourceEnum custFromSourceEnum) {
        return custFromSourceEnum.getFromSource() + "-" + custFromSourceEnum.getActionType().getType();
    }

    public static CustFromSourceEnum getEnumByString(String custFromSource) {
        if (StringUtils.isBlank((CharSequence)custFromSource)) {
            return null;
        }
        String[] params = custFromSource.split("-");
        if (params.length != 2) {
            return null;
        }
        if (!SOURCE_MAP.containsKey(params[0])) {
            return null;
        }
        Map<String, CustFromSourceEnum> actionTypeMap = SOURCE_MAP.get(params[0]);
        if (MapUtils.isEmpty(actionTypeMap) || !actionTypeMap.containsKey(params[1])) {
            return null;
        }
        return actionTypeMap.get(params[1]);
    }

    public static String getActionTypeByString(String custFromSource) {
        if (StringUtils.isBlank((CharSequence)custFromSource)) {
            return null;
        }
        CustFromSourceEnum enumByString = CustFromSourceEnum.getEnumByString(custFromSource);
        if (enumByString == null) {
            return null;
        }
        return enumByString.getActionType().getType();
    }

    public static boolean isCluePush(String custFromSource) {
        if (StringUtils.isBlank((CharSequence)custFromSource)) {
            return false;
        }
        return CLUE_SOURCE_SET.contains(custFromSource);
    }

    public static boolean isSellerBuild(String custFromSource) {
        if (StringUtils.isBlank((CharSequence)custFromSource)) {
            return false;
        }
        return SELLER_SOURCE_SET.contains(custFromSource);
    }

    public static boolean isPhoneRepeatBuild(String custFromSource) {
        if (StringUtils.isBlank((CharSequence)custFromSource)) {
            return false;
        }
        return SELLER_SOURCE_CHECK_PHONE_SET.contains(custFromSource);
    }

    public static boolean isIntroduce(String custFromSource) {
        if (StringUtils.isBlank((CharSequence)custFromSource)) {
            return false;
        }
        return INTRODUCE_SOURCE_LIST.contains(custFromSource);
    }

    public static boolean isIntroduceOrOld(String custFromSource) {
        if (StringUtils.isBlank((CharSequence)custFromSource)) {
            return false;
        }
        return INTRODUCE_OR_OLD_SOURCE_LIST.contains(custFromSource);
    }

    public String getFromSource() {
        return this.fromSource;
    }

    public CustActionTypeEnum getActionType() {
        return this.actionType;
    }

    public String getDesc() {
        return this.desc;
    }

    private CustFromSourceEnum(String fromSource, CustActionTypeEnum actionType, String desc) {
        this.fromSource = fromSource;
        this.actionType = actionType;
        this.desc = desc;
    }

    static {
        SOURCE_MAP = null;
        CLUE_SOURCE_SET = Sets.newHashSet((Iterable)Arrays.stream(CustFromSourceEnum.values()).filter(custFromSourceEnum -> {
            if (custFromSourceEnum.equals((Object)PUB_TENCENT_CLUE_WX_PAY_VIP)) {
                return false;
            }
            if ("01_02".equals(custFromSourceEnum.getFromSource())) {
                return true;
            }
            if ("01_03".equals(custFromSourceEnum.getFromSource())) {
                return true;
            }
            return "01_04".equals(custFromSourceEnum.getFromSource());
        }).map(CustFromSourceEnum::getStringByEnum).collect(Collectors.toSet()));
        SELLER_SOURCE_SET = Sets.newHashSet((Object[])new String[]{CustFromSourceEnum.getStringByEnum(SELLER_OLD_CUST), CustFromSourceEnum.getStringByEnum(SELLER_INTRODUCE_CUST), CustFromSourceEnum.getStringByEnum(OTHER_OFFLINE_COMMUNITY_INTRODUCE)});
        Arrays.stream(CustFromSourceEnum.values()).forEach(sourceEnum -> {
            if (MapUtils.isEmpty(SOURCE_MAP)) {
                SOURCE_MAP = new HashMap<String, Map<String, CustFromSourceEnum>>();
            }
            Map actionTypeMap = SOURCE_MAP.computeIfAbsent(sourceEnum.getFromSource(), k -> new HashMap());
            actionTypeMap.put(sourceEnum.getActionType().getType(), sourceEnum);
        });
        SELLER_SOURCE_CHECK_PHONE_SET = Sets.newHashSet((Object[])new String[]{CustFromSourceEnum.getStringByEnum(SELLER_OLD_CUST), CustFromSourceEnum.getStringByEnum(SELLER_INTRODUCE_CUST), CustFromSourceEnum.getStringByEnum(OTHER_OFFLINE_COMMUNITY)});
        INTRODUCE_SOURCE_LIST = Arrays.asList(CustFromSourceEnum.getStringByEnum(SELLER_INTRODUCE_CUST_FOR_CHECK), CustFromSourceEnum.getStringByEnum(SELLER_INTRODUCE_CUST), CustFromSourceEnum.getStringByEnum(OTHER_OFFLINE_INVITE_INTRODUCE), CustFromSourceEnum.getStringByEnum(OTHER_OFFLINE_COMMUNITY_INTRODUCE), CustFromSourceEnum.getStringByEnum(OTHER_ONLINE_MARKET_LIVE_INTRODUCE));
        INTRODUCE_OR_OLD_SOURCE_LIST = Arrays.asList(CustFromSourceEnum.getStringByEnum(SELLER_INTRODUCE_CUST_FOR_CHECK), CustFromSourceEnum.getStringByEnum(SELLER_INTRODUCE_CUST), CustFromSourceEnum.getStringByEnum(OTHER_OFFLINE_INVITE_INTRODUCE), CustFromSourceEnum.getStringByEnum(OTHER_OFFLINE_COMMUNITY_INTRODUCE), CustFromSourceEnum.getStringByEnum(OTHER_ONLINE_MARKET_LIVE_INTRODUCE), CustFromSourceEnum.getStringByEnum(SELLER_OLD_CUST));
    }
}

