package cn.com.duiba.oto.dto.oto.cust.custInterview;

import cn.com.duiba.oto.enums.OtoCustInterviewStatusEnum;
import cn.com.duiba.oto.enums.cust.OtoCustPhaseEnum;
import cn.com.duiba.oto.enums.interview.InterviewTypeEnum;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * 创建面访基础参数
 *
 * @author xiaotian
 * @version 1.0
 * @date 2023-05-06 09:52
 */
@Data
public class CustInterviewBaseBean implements Serializable {


    private static final long serialVersionUID = 3761170603027105377L;

    /**
     * 来源id(产生面访的业务主键id)
     */
    @NotEmpty
    String bizId;
    /**
     * 客户面访来源
     *
     * @see cn.com.duiba.oto.enums.interview.CustInterviewBizTypeEnum
     */
    @NotNull
    private Integer interviewFromSource;
    /**
     * 客户id
     */
    @NotNull
    private Long custId;

    /**
     * 销售ID
     */
    @NotNull
    private Long sellerId;

    /**
     * 面访场景配置ID 【tb_cust_interview_conf】
     */
    @NotNull
    private Long interviewConfId;

    /**
     * 见面目的
     *
     * @see cn.com.duiba.oto.enums.cust.OtoCustPhaseEnum
     */
    @NotNull
    private Integer custPhase = OtoCustPhaseEnum.NONE.getCode();

    /**
     * 面访类型
     *
     * @see cn.com.duiba.oto.enums.interview.InterviewTypeEnum
     */
    private Integer interviewType = InterviewTypeEnum.ORDINARY_INTERVIEW.getCode();

    /**
     * 产生面访的时间（默认当前时间）
     */
    private Date interviewTime = new Date();

    /**
     * 面访状态：{@link cn.com.duiba.oto.enums.OtoCustInterviewStatusEnum}
     */
    private Integer interviewStatus = OtoCustInterviewStatusEnum.INTERVIEW_FINISH.getStatus();

}
