package cn.com.duiba.oto.oto.service.api.remoteservice.cust;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.cust.form.CustFormDetailDto;
import cn.com.duiba.oto.dto.oto.cust.form.OtoCustFormDto;
import cn.com.duiba.oto.dto.oto.cust.form.OtoFormLibraryDto;
import cn.com.duiba.oto.param.oto.cust.form.CustFormLibraryStatusParam;
import cn.com.duiba.oto.param.oto.cust.form.CustLibraryUpdateParam;
import cn.com.duiba.oto.param.oto.cust.form.RemoteCustFormDetailParam;
import cn.com.duiba.oto.param.oto.cust.form.RemoteCustFormOrderParam;
import cn.com.duiba.oto.param.oto.cust.form.RemoteCustFormSaveDetailParam;
import cn.com.duiba.oto.param.oto.cust.form.RemoteCustFormSaveLibraryDetailParam;
import cn.com.duiba.oto.param.oto.cust.form.RemoteCustFormSaveParam;
import cn.com.duiba.oto.param.oto.cust.form.RemoteCustFormStatusParam;
import cn.com.duiba.oto.param.oto.cust.form.RemoteCustFormSubmitParam;

import java.util.List;


/**
 * 客户资料表单
 *
 * @author xiaotian
 */

@AdvancedFeignClient
public interface RemoteOtoCustFormQuestionService {

    /**
     * 新增表单
     *
     * @param remoteCustFormSaveParam
     * @return
     */
    boolean saveForm(RemoteCustFormSaveParam remoteCustFormSaveParam) throws BizException;

    /**
     * 表单状态
     *
     * @param remoteCustFormStatusParam
     * @return
     */
    boolean formStatus(RemoteCustFormStatusParam remoteCustFormStatusParam);

    /**
     * 表单移动
     *
     * @param remoteCustFormOrderParam
     * @return
     */
    boolean order(RemoteCustFormOrderParam remoteCustFormOrderParam);

    /**
     * 获取所有表单
     *
     * @return
     */
    List<OtoCustFormDto> getAllForm();

    /**
     * 获取所有开启的表单
     *
     * @return
     */
    List<OtoCustFormDto> getAllOpenedForm();

    /**
     * 新增编辑表单详情
     *
     * @param remoteCustFormSaveDetailParam
     * @return
     */
    boolean saveFormQuestion(RemoteCustFormSaveDetailParam restFormSaveDetailParam) throws BizException;

    /**
     * 提交客户表单
     *
     * @param remoteCustFormSaveDetailParam
     * @return
     */
    boolean submitFormQuestion(RemoteCustFormSubmitParam remoteCustFormSaveDetailParam);


    /**
     * 获取表单详情
     *
     * @param remoteCustFormDetailParam
     * @return
     */
    List<CustFormDetailDto> getFromDetailDto(RemoteCustFormDetailParam remoteCustFormDetailParam);

    /**
     * 新增资料库（or更新）
     *
     * @param param
     * @return
     */
    Boolean saveLibraryDetail(RemoteCustFormSaveLibraryDetailParam param) throws BizException;

    /**
     * 更新资料库状态
     *
     * @param param
     * @return
     */
    Boolean publishLibrary(CustFormLibraryStatusParam param);

    /**
     * 升级客户资料库
     *
     * @param param
     * @return
     */
    Boolean updateCustLibrary(CustLibraryUpdateParam param);

    /**
     * 获取客户填写的资料库id
     *
     * @param custId
     * @return
     */
    Long custLibrary(Long custId);

    /**
     * 根据资料库id，获取所有的资料组id
     *
     * @param libraryId
     * @return
     */
    List<Long> formsByLibrary(Long libraryId);

    /**
     * 获取所有资料库
     *
     * @return
     */
    List<OtoFormLibraryDto> librarys();
}
